//---------------------------------------------------------------------------
#include <vcl.h>
#include <errno.h>
#include <winnls.h>
#pragma hdrstop

#include "Unit2.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm2::Button1Click(TObject *Sender)
{
    interrupt = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FormCreate(TObject *Sender)
{
    set_language();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::fcd2iso(char *fcd_file)
{
	FILE *out;

	FCD fcd;

	char *out_file;
	int i, n;

	if(!open_fcd_file(fcd_file, &fcd)){
        fcd_open_error(fcd_file);
		Close();
	}

    if(!fcd.dtl.num){
        fcd_has_no_data_track(fcd.path);
        exit(EXIT_FAILURE);
    }

    if(mode & MODE_VERBOSE){
        for(i=0,n=0;i<fcd.dtl.num;i++){
            n += fcd.dtl.dt[i].ti->num_of_block;
        }
        PB->Max = n;
        PB->Position = 0;
        Show();
    }

    working = true;

	for(i=0;i<fcd.dtl.num;i++){

        out_file = concoct_track_name(&fcd, fcd.dtl.dt[i].ti->index);
        if(FileExists(out_file)){
            if(query_overwrite(out_file) != IDOK){
                close_fcd_file(&fcd);
                free(out_file);
                PB->Max -= fcd.dtl.dt[i].ti->num_of_block;
                continue;
            }
        }

        out = fopen(out_file, "wb");
        if(out == NULL){
            file_create_error(out_file);
            close_fcd_file(&fcd);
            free(out_file);
            Close();
		}

		if(mode & MODE_VERBOSE){
			set_filename_view(out_file);
            track_view->Caption = Format("%d/%d", ARRAYOFCONST((fcd.dtl.dt[i].ti->index+1, fcd.cdi.num_of_track)));
		}

		n = convert_to_iso(&fcd, out);
		fclose(out);

		if(!n){ /* s  f */
			remove(out_file);
            break;
		}

        free(out_file);
	}

    working = false;

    close_fcd_file(&fcd);
    
	Close();
}
//---------------------------------------------------------------------------
LBN __fastcall TForm2::convert_to_iso(FCD *in, FILE *out)
{
	int i;

    int track;
	size_t block_size;
	size_t skip_size;

    data_track *dt;
	cd_image_buffer buffer;

    dt = in->dtl.current;
    track = in->dtl.current->ti->index + 1;

	/***********************************************************
	    gbN`𒲂ׁAubNTCYݒ肷
     ***********************************************************/
    buffer.block_size = dt->ti->block_size;

    switch(dt->ti->type){
	case FCD_TYPE_ISO:
		block_size = 2048;
		break;
	case FCD_TYPE_RAW:

		if(mode & MODE_BLOCK_2048){
			block_size = 2048;
		}else if(mode & MODE_BLOCK_2336){
			block_size = 2336;
		}else{
			block_size = 2352;
		}

		if(!(mode & MODE_XA_SILENCE)){
            if(raw_mode_track_warning(in->path, track, block_size) != IDOK){
                Form1->Show();
                return 0;
            }
		}
		break;
	case FCD_TYPE_DA:
        audio_mode_track_error(in->path, track);
		return 0;
	default:
        unknown_mode_track_error(in->path, track);
		return 0;
	}

	/***********************************************************
	     ktH[}bǧ؂ƌx̕\
     ***********************************************************/
	switch(dt->compress){
	case FCD_COMPRESS_NO:
	case FCD_COMPRESS_STD:
	case FCD_COMPRESS_HI:
		/* nothing to do */
		break;
	default:
        unknown_compression_error(in->path, track);
		return 0;
	}

    /***********************************************************
        擪ubNǂ݂ށiȗĂ 16 ubN܂߂āj
     ***********************************************************/
    if(!read_fcd_first_blocks(in, &buffer)){
        free(buffer.data);
        return 0;
    }

	/***********************************************************
	    ϊp[^̐ݒ
     ***********************************************************/
	if((dt->ti->type == FCD_TYPE_ISO) || (mode & MODE_BLOCK_2352)){
		skip_size = 0;
	}else if(mode & MODE_BLOCK_2336){
		skip_size = 16;
	}else{
        if(buffer.mode == 1){
            skip_size = 16;
        }else{
            skip_size = 24;
            
            /* {͂ƌɏׂǁA蔲   */
            /* 2352 -> 2048 ϊgĂȂ  */
            /* ꂶʖڂĕAĂΒ܂ */

        }            
	}

	/***********************************************************
	    ϊJn
     ***********************************************************/
	do{
		for(i=0;i<buffer.num_of_block;i++){
			if(fwrite((buffer.data + (i * buffer.block_size) + skip_size), 1, block_size, out) != block_size){
                file_write_error("FCD");
				exit(EXIT_FAILURE);
			}
		}

		if(mode & MODE_VERBOSE){
            PB->Position += buffer.num_of_block;
			block_view->Caption = Format("%5d / %5d", ARRAYOFCONST(((int)dt->position, (int)dt->ti->num_of_block)));
		}

		free(buffer.data);

        Application->ProcessMessages();

        if(interrupt){
            switch(query_interrupt()){
            case IDOK:
                return 0;
            default:
                interrupt = false;
            }
        }
	}while((dt->position < dt->ti->num_of_block) && read_fcd_data(in, &buffer));

	/***********************************************************
	   ̃f[^gbN݂΁A̐擪Ɉړ
     ***********************************************************/
	if(dt->index+1 < in->dtl.num){
		if(!go_next_track(in)){
            move_next_track_error(in->path, (in->dtl.current->ti->index + 1));
			return 0;
		}
	}

	return dt->position;
}
//---------------------------------------------------------------------------
char * __fastcall TForm2::concoct_track_name(FCD *fcd, int track)
{
	char *r;
    char *folder;
	char *basename;
	AnsiString sfx;

    basename = get_basename(fcd->path);
    folder = Form1->get_iso_folder(fcd->path);

    switch(fcd->cdi.ti[track].type){
    case FCD_TYPE_ISO:
        sfx = LowerCase(Form1->block_2048_suffix->Caption);
        break;
    case FCD_TYPE_RAW:
        if(mode & MODE_BLOCK_2048){
            sfx = LowerCase(Form1->block_2048_suffix->Caption);
        }else if(mode & MODE_BLOCK_2352){
            sfx = LowerCase(Form1->block_2352_suffix->Caption);
        }else{
            sfx = LowerCase(Form1->block_2336_suffix->Caption);
        }
        break;
    case FCD_TYPE_DA:
        sfx = ".cda";
        break;
    case FCD_TYPE_UNKNOWN:
    default:
        sfx = ".ukn";
    }

	r = (char *)malloc(strlen(folder) + strlen(basename) + sfx.Length() + 6);

	sprintf(r, "%s\\%s_%02d%s", folder, basename, track+1, sfx.c_str());
	free(basename);
    free(folder);

	return r;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FormCloseQuery(TObject *Sender, bool &CanClose)
{
    if(working){
        switch(query_interrupt()){
        case IDOK:
            CanClose = true;
            break;
        default:
            CanClose = false;
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::iso2fcd(char *iso_file)
{
    int i;
    char *folder;
    char *fcd_file;
    char fn[FILENAME_MAX];
    TSearchRec sr;
    AnsiString pattern;
    FCD fcd;

	/***********************************************************
	      gbNXg쐬
     ***********************************************************/
    init_fcd(&fcd);

    if(!check_sfx(iso_file, ".wav")){
        if(check_sfx(iso_file, ".mp3")){
            mode |= MODE_ENABLE_MP3;
        }else{
            if(!add_track(&fcd, iso_file)){
                add_track_data_error(iso_file);
                exit(EXIT_FAILURE);
            }
        }
    }

    folder = get_directory(iso_file);
    pattern = folder;
    pattern += "*.wav";

    if(FindFirst(pattern, faAnyFile, sr) == 0){
        sprintf(fn, "%s%s", folder, sr.Name.c_str());
        add_track(&fcd, fn);
        while(FindNext(sr) == 0){
            sprintf(fn, "%s%s", folder, sr.Name.c_str());
            if(!add_track(&fcd, fn)){
                add_track_wav_error(fn);
            }
            if(fcd.cdi.num_of_track >= TRACK_MAX){
                break;
            }
        }
        FindClose(sr);
    }

    if(mode & MODE_ENABLE_MP3){
        pattern = folder;
        pattern += "*.mp3";
        if(FindFirst(pattern, faAnyFile, sr) == 0){
            sprintf(fn, "%s%s", folder, sr.Name.c_str());
            add_track(&fcd, fn);
            while(FindNext(sr) == 0){
                sprintf(fn, "%s%s", folder, sr.Name.c_str());
                if(!add_track(&fcd, fn)){
                    add_track_mp3_error(fn);                    
                }
                if(fcd.cdi.num_of_track >= TRACK_MAX){
                    break;
                }
            }
            FindClose(sr);
        }
    }

    sort_track_by_name(&fcd);

	/***********************************************************
	      FCD t@Cݒ
     ***********************************************************/
    strcpy(fn, read_filename(iso_file));
    cut_sfx(fn);
    
    if(has_separable_tail_num(fn)){
        cut_tail_digits(fn);
        cut_tail_separater(fn);
    }
    
    free(folder);
    folder = Form1->get_fcd_folder(iso_file);

    fcd_file = (char *)malloc(strlen(folder) + strlen(fn) + 6);
    sprintf(fcd_file, "%s\\%s%s", folder, fn, ".fcd");
    fcd.path = fcd_file;
    free(folder);

    /***********************************************************
          fcd.cdi.desc ̐ݒ
     ***********************************************************/
    if(!fcd.dtl.num || !fcd.dtl.dt[0].iso_xa){
        /* f[^gbN݂ꍇ́AC[W
           {[ʎq fcd.cdi.desc ɐݒ肳Ă */
        strcpy(fcd.cdi.desc, fn);
    }
    
	/***********************************************************
          gbNXgݒ
     ***********************************************************/
    if(mode & MODE_SETUP_TRACK){
        Form4->set_list(&fcd);
        if(!(Form4->ShowModal() == mrOk)){
            exit(EXIT_FAILURE);
        }
    }

	/***********************************************************
	      ㏑\mF
     ***********************************************************/
    if(mode & MODE_OVERWRITE){
        if(fcd.dtl.num > 1 ){
            mode &= (~MODE_OVERWRITE);
            cant_overwrite_conversion_multiple_image();
        }else if(fcd.dtl.num == 0){
            mode &= (~MODE_OVERWRITE);
            cant_overwrite_conversion_audio_cd();
        }else if(fcd.dtl.dt[0].ti->index != 0){
            mode &= (~MODE_OVERWRITE);
            cant_overwrite_conversion_cd_extra();
        }else if(fcd.dtl.dt[0].ti->block_size == 2336){
            mode &= (~MODE_OVERWRITE);
            cant_overwrite_conversion_2336_image();
        }else if(!compare_drive(iso_file, fcd_file)){
            mode &= (~MODE_OVERWRITE);
            cant_overwrite_conversion_different_drive();
        }
    }

	/***********************************************************
	      FCD t@C쐬
     ***********************************************************/

    if(mode & MODE_OVERWRITE){
        fcd.stream = fopen(iso_file, "rb+");
        if(fcd.stream == NULL){
            file_open_error(iso_file);
            exit(EXIT_FAILURE);
        }
        fcd.dtl.dt[0].offset = fcd.dtl.dt[0].ti->block_size * 16;
    }else{

        if(FileExists(fcd.path)){
            if(query_overwrite(fcd.path) != IDOK){
                exit(EXIT_FAILURE);
            }
        }

        fcd.stream = fopen(fcd.path, "wb");
        if(fcd.stream == NULL){
            file_create_error(fcd.path);
            exit(EXIT_FAILURE);
        }
    }

	/***********************************************************
	      vOXo[̏ݒ
     ***********************************************************/

    PB->Max = 0;
    if(!(mode & MODE_OVERWRITE)){
        for(i=0;i<fcd.dtl.num;i++){
            PB->Max += fcd.dtl.dt[i].ti->num_of_block * fcd.dtl.dt[i].ti->block_size;
        }
    }
    for(i=0;i<fcd.atl.num;i++){
        if(check_sfx(fcd.atl.at[i].ti->filename, ".mp3")){
            PB->Max += fcd.atl.at[i].byte;
        }else if(!compare_directory(fcd.path, fcd.atl.at[i].ti->filename)){
            PB->Max += fcd.atl.at[i].byte;
        }
    }

    if(mode & MODE_VERBOSE && PB->Max){
        Show();
    }
    working = true;

	/***********************************************************
	      ϊJn
     ***********************************************************/
    write_fcd_info(&fcd, fcd.stream);

    if(!(mode & MODE_OVERWRITE)){
        for(i=0;i<fcd.dtl.num;i++){

            if(mode & MODE_VERBOSE){
                set_filename_view(fcd.dtl.dt[i].ti->filename);
                track_view->Caption = Format("%d/%d", ARRAYOFCONST((fcd.dtl.dt[i].ti->index+1, fcd.cdi.num_of_track)));
            }

            if(!convert_to_fcd(&fcd)){
                fclose(fcd.stream);
                remove(fcd.path);
                exit(EXIT_FAILURE);
            }
        }
    }

    write_fcd_info(&fcd, fcd.stream);
    fclose(fcd.stream);

    if(mode & MODE_OVERWRITE){
        if(rename(iso_file, fcd.path)){
            file_rename_error(errno, iso_file, fcd.path);
            exit(EXIT_FAILURE);
        }
    }

    for(i=0;i<fcd.atl.num;i++){
        if(check_sfx(fcd.atl.at[i].ti->filename, ".mp3")){
            if(mode & MODE_VERBOSE){
                set_filename_view(fcd.atl.at[i].ti->filename);
                track_view->Caption = Format("%d/%d", ARRAYOFCONST((fcd.atl.at[i].ti->index+1, fcd.cdi.num_of_track)));
            }
            copy_mp3(&fcd, i);
        }else if(!compare_directory(fcd.path,  fcd.atl.at[i].ti->filename)){
            if(mode & MODE_VERBOSE){
                set_filename_view(fcd.atl.at[i].ti->filename);
                track_view->Caption = Format("%d/%d", ARRAYOFCONST((fcd.atl.at[i].ti->index+1, fcd.cdi.num_of_track)));
            }
            copy_wav(&fcd, i);
        }
    }

    working = false;
    if(fcd_file != fcd.path){
        free(fcd.path);
    }
    free(fcd_file);

    Close();
}
//---------------------------------------------------------------------------
LBN __fastcall TForm2::convert_to_fcd(FCD *fcd)
{
    int n;
	cd_image_buffer buffer;
    data_track *dt;
    FILE *in;

    dt = fcd->dtl.current;
    
    in = fopen(dt->ti->filename, "rb");
    if(in == NULL){
        return 0;
    }

    if(!dt->ti->index){ /* only first track */
        fseek(in, dt->ti->block_size * 16, SEEK_SET);
        dt->position += 16;
    }

    buffer.block_size = dt->ti->block_size;
    buffer.mode = dt->mode;
    buffer.data = (char *)malloc(buffer.block_size * 16);

    while((n = fread(buffer.data, 1, (buffer.block_size * 16), in)) > 0){
        buffer.num_of_block = n / buffer.block_size;
        if(write_fcd_data(&buffer, fcd) != (n / buffer.block_size)){
            file_write_error(fcd->path);
            return 0;
        }

        if(mode & MODE_VERBOSE){
            PB->Position += buffer.num_of_block * buffer.block_size;
            block_view->Caption = Format("%5d / %5d", ARRAYOFCONST(((int)dt->position, (int)dt->ti->num_of_block)));
        }

        Application->ProcessMessages();

        if(interrupt){
            switch(query_interrupt()){
            case IDOK:
                fclose(in);
                return 0;
            default:
                interrupt = false;
            }
        }
    }

    if(dt->index < fcd->dtl.num){
        fcd->dtl.current += 1;
        fcd->dtl.current->offset = ftell(fcd->stream);
    }

    free(buffer.data);
    
    return dt->position;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::copy_mp3(FCD *fcd, int index)
{
    char out_path[FILENAME_MAX];

    strcpy(out_path, fcd->path);
    cut_filename(out_path);
    strcat(out_path, read_filename(fcd->atl.at[index].ti->filename));
    cut_sfx(out_path);
    strcat(out_path, ".wav");

    wrap_mp3(fcd->atl.at[index].ti->filename, out_path);
}
//---------------------------------------------------------------------------
void __fastcall TForm2::wrap_only(char *mp3_file)
{
    MP3_INFO mp3;
    char *wav_file;

    if(mode & MODE_VERBOSE){
        if(!open_mp3_file(mp3_file, &mp3)){
            mp3_open_error(mp3_file);
            exit(EXIT_FAILURE);
        }

        Label2->Visible = false;
        set_filename_view(mp3_file);
        PB->Max = mp3.length;
        Show();

        close_mp3_file(&mp3);
    }

    wav_file = change_sfx(mp3_file, ".wav");

    wrap_mp3(mp3_file, wav_file);

    free(wav_file);

    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::wrap_mp3(char *mp3_file, char *wav_file)
{
    int d,u;
    MP3_INFO mp3;
    FILE *out;
    char *buf;
    size_t buf_size;
    size_t n;
    LBN num_of_block;

    char riff_head[58] = {
    	 'R',  'I',  'F',  'F', 0x00, 0x00, 0x00, 0x00,  'W',  'A',
         'V',  'E',  'f',  'm',  't',  ' ', 0x1E, 0x00, 0x00, 0x00,
        0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x71, 0x05,
         'd',  'a',  't',  'a', 0x00, 0x00, 0x00, 0x00
    };

    if(!open_mp3_file(mp3_file, &mp3)){
        mp3_open_error(mp3_file);
        return;
    }

    /* setup RIFF/WAV header */
    int32_to_le_char_array(mp3.length + 50, riff_head + 4);

    if(mp3.stereo){
        int16_to_le_char_array(2, riff_head + 22);
    }else{
        int16_to_le_char_array(1, riff_head + 22);
    }

    int32_to_le_char_array(mp3.sample, riff_head + 24);

    int32_to_le_char_array(mp3.bitrate * 125, riff_head + 28);

    int32_to_le_char_array(mp3.padding, riff_head + 40);

    if(mp3.stereo){
        int16_to_le_char_array(mp3.bitrate * 26 / 8 + 1, riff_head + 44);
    }else{
        int16_to_le_char_array(mp3.bitrate * 26 / 8, riff_head + 44);
    }

    int32_to_le_char_array(mp3.length, riff_head + 54);

    /* open output file */
    out = fopen(wav_file, "wb");
    if(out == NULL){
        file_create_error(wav_file);
        exit(EXIT_FAILURE);
    }

    /* write to file */
    if(fwrite(riff_head, 1, 58, out) != 58){
        file_write_error(wav_file);
        exit(EXIT_FAILURE);
    }

    num_of_block = (mp3.length * 3) / (mp3.bitrate * 5);
    if((mp3.length * 3) % (mp3.bitrate * 5)){
        num_of_block += 1;
    }

    buf_size = 32768;
    buf = (char *)malloc(buf_size);

    d = mp3.length / num_of_block;
    u = 0;
    while((n = fread(buf, 1, buf_size, mp3.stream)) > 0){
        if(fwrite(buf, 1, n, out) != n){
            file_write_error(wav_file);
            exit(EXIT_FAILURE);
        }

        if(mode & MODE_VERBOSE){
            PB->Position += n;
            u += n;
            block_view->Caption = Format("%5d / %5d", ARRAYOFCONST((u/d, (int)num_of_block)));
        }

        Application->ProcessMessages();

        if(interrupt){
            switch(query_interrupt()){
            case IDOK:
                exit(EXIT_FAILURE);
            default:
                interrupt = false;
            }
        }
    }

    close_mp3_file(&mp3);
    fclose(out);
    free(buf);
}
//---------------------------------------------------------------------------
void __fastcall TForm2::copy_wav(FCD *fcd, int index)
{
    int d,u;
    char out_path[FILENAME_MAX];
    char *buf;
    size_t buf_size;
    size_t n;
    FILE *in,*out;

    strcpy(out_path, fcd->path);
    cut_filename(out_path);
    strcat(out_path, read_filename(fcd->atl.at[index].ti->filename));

    in = fopen(fcd->atl.at[index].ti->filename, "rb");
    if(in == NULL){
        file_open_error(fcd->atl.at[index].ti->filename);
        exit(EXIT_FAILURE);
    }

    out = fopen(out_path, "wb");
    if(out == NULL){
        file_create_error(out_path);
        exit(EXIT_FAILURE);
    }

    buf_size = 32768;
    buf = (char *)malloc(buf_size);

    d = fcd->atl.at[index].byte / fcd->atl.at[index].ti->num_of_block;
    u = 0;
    while((n = fread(buf, 1, buf_size, in)) > 0){
        if(fwrite(buf, 1, n, out) != n){
            file_write_error(out_path);
            exit(EXIT_FAILURE);
        }

        if(mode & MODE_VERBOSE){
            PB->Position += n;
            u += n;
            block_view->Caption = Format("%5d / %5d", ARRAYOFCONST((u/d, (int)fcd->atl.at[index].ti->num_of_block)));
        }

        Application->ProcessMessages();

        if(interrupt){
            switch(query_interrupt()){
            case IDOK:
                exit(EXIT_FAILURE);
            default:
                interrupt = false;
            }
        }
    }

    fclose(in);
    fclose(out);
    free(buf);
}
//---------------------------------------------------------------------------
void __fastcall TForm2::WMSysCommand(TWMSysCommand& Msg)
{
    if ( (Msg.CmdType & 0xfff0) == SC_MINIMIZE ){
        Application->Minimize();
    }else{
        TForm::Dispatch(&Msg);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::set_filename_view(char *filename)
{
    int n;

    n = strlen(filename);

#define SHOW_CHAR_MAX 36
    if(n > SHOW_CHAR_MAX){
        filename += (n - SHOW_CHAR_MAX);
        filename_view->Caption = "..";
        filename_view->Caption = filename_view->Caption + filename;
    }else{
        filename_view->Caption = filename;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::dao2fcd(char *cue_file)
{
    int i;

    DAO_INFO p;
    FCD fcd;

    init_fcd(&fcd);

    if(check_sfx(cue_file, ".cue")){
        if(! open_cue_file(cue_file, &p) ){
            cue_open_error(cue_file);
            exit(EXIT_FAILURE);
        }
    }else if(check_sfx(cue_file, ".ccd")){
        if(! open_ccd_file(cue_file, &p) ){
            ccd_open_error(cue_file);
            exit(EXIT_FAILURE);
        }
    }else if(check_sfx(cue_file, ".cdi")){
        if( ! open_cdi_file(cue_file, &p) ){
            cdi_open_error(cue_file);
            exit(EXIT_FAILURE);
        }
    }else if(check_sfx(cue_file, ".nrg")){
        if(! open_nrg_file(cue_file, &p) ){
            if(is_track_image_nrg(cue_file)){
                iso2fcd(cue_file);
                return;
            }else{
                nrg_open_error(cue_file);
                exit(EXIT_FAILURE);
            }
        }
    }
    
    DAO_INFO_to_FCD(&p, &fcd);

    if(FileExists(fcd.path)){
        if(query_overwrite(fcd.path) != IDOK){
            exit(EXIT_FAILURE);
        }
    }

    fcd.stream = fopen(fcd.path, "wb");
    if(fcd.stream == NULL){
        file_create_error(fcd.path);
        exit(EXIT_FAILURE);
    }

    PB->Max = 0;
    for(i=0;i<p.num_of_track;i++){
        PB->Max += p.track[i].num_of_block;
    }

    if(mode & MODE_VERBOSE){
        Show();
    }
    working = true;

    write_fcd_info(&fcd, fcd.stream);

    for(i=0;i<p.num_of_track;i++){
        if(p.track[i].type == DAO_TRACK_TYPE_AUDIO){
            if(mode & MODE_VERBOSE){
                set_filename_view(fcd.cdi.ti[i].filename);
                track_view->Caption = Format("%d/%d", ARRAYOFCONST((i+1, p.num_of_track)));
            }
            if(! bin2wav(&(p.track[i]), fcd.cdi.ti[i].filename)){
                fclose(fcd.stream);
                remove(fcd.path);
                remove(fcd.cdi.ti[i].filename);
                exit(EXIT_FAILURE);
            }
        }else{
            if(mode & MODE_VERBOSE){
                set_filename_view(fcd.path);
                track_view->Caption = Format("%d/%d", ARRAYOFCONST((i+1, p.num_of_track)));
            }
            if(! bin2fcd(&(p.track[i]), &fcd)){
                fclose(fcd.stream);
                remove(fcd.path);
                exit(EXIT_FAILURE);
            }
        }
    }

    write_fcd_info(&fcd, fcd.stream);
    fclose(fcd.stream);

    working = false;
    free(fcd.path);

    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::DAO_INFO_to_FCD(DAO_INFO *in, FCD *out)
{
    int i;
    char *folder;

    data_track *dt;
    audio_track *at;
    track_infomation *ti;

    folder = Form1->get_fcd_folder(in->path);

    strcpy(out->cdi.desc, read_filename(in->path));
    cut_sfx(out->cdi.desc);

    out->path = (char *)malloc(strlen(folder)+strlen(out->cdi.desc)+7);
    sprintf(out->path, "%s\\%s.fcd", folder, out->cdi.desc);

    out->cdi.num_of_track = in->num_of_track;

    for(i=0;i<in->num_of_track;i++){

        ti = out->cdi.ti + i;
        ti->index = i;
        ti->start = in->track[i].start;
        ti->num_of_block = in->track[i].num_of_block;
        ti->post_gap = 0;

        if(i>0){
            (ti-1)->post_gap = ti->start - (ti-1)->num_of_block - (ti-1)->start;
        }

        ti->block_size = in->track[i].block_size;

        if(in->track[i].type == DAO_TRACK_TYPE_AUDIO){

            out->type |= FCD_TYPE_DA;
            ti->type = FCD_TYPE_DA;

            at = out->atl.at + out->atl.num;
            at->index = out->atl.num;
            out->atl.num += 1;

            ti->p = (void *)at;
            at->ti = ti;

            at->byte = ti->num_of_block * ti->block_size;

            sprintf(ti->filename, "%s\\%s_%02d.wav", folder, out->cdi.desc, i+1);

        }else{

            if(in->track[i].block_size == 2048){
                out->type |= FCD_TYPE_ISO;
                ti->type = FCD_TYPE_ISO;
            }else{
                out->type |= FCD_TYPE_RAW;
                ti->type = FCD_TYPE_RAW;
            }

            dt = out->dtl.dt + out->dtl.num;
            dt->index = out->dtl.num;
            out->dtl.num += 1;

            ti->p = (void *)dt;
            dt->ti = ti;

            dt->compress = FCD_COMPRESS_NO;

            if(in->track[i].type == DAO_TRACK_TYPE_MODE1){
                dt->mode = 1;
            }else{
                dt->mode = 2;
            }

        }
    }

    out->cdi.total = LBN_to_MSF(ti->start + ti->num_of_block);

    free(folder);

}
//---------------------------------------------------------------------------
LBN __fastcall TForm2::bin2fcd(dao_track *bin, FCD *out)
{
    LBN i,j;
    size_t n;
    FILE *in;
    cd_image_buffer buffer;
    data_track *dt;

    static const char sync[12] = {
        0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0x00
    };

    in = fopen(bin->path, "rb");
    if(in == NULL){
        return 0;
    }
    fseek(in, bin->offset, SEEK_SET);

    dt = (data_track *)out->cdi.ti[bin->index].p;
    out->dtl.current = dt;
    dt->offset = ftell(out->stream);

    if(!bin->index){
        fseek(in, bin->block_size * 16, SEEK_CUR);
        dt->position = 16;
    }

    buffer.block_size = bin->block_size;
    buffer.mode = dt->mode;
    buffer.data = (char *)malloc(bin->block_size * 16);

    for(i=dt->position,j=0;i<bin->num_of_block;i++,j++){

        j %= 16;

        n = fread(buffer.data+(j*buffer.block_size), 1, (buffer.block_size), in);
        if(n != buffer.block_size){
            free(buffer.data);
            return 0;
        }
        if(buffer.block_size == 2352 && memcmp(buffer.data+(j*buffer.block_size), sync, 12) != 0){
            PB->Max -= (bin->num_of_block - i);
            bin->num_of_block = i;
            out->cdi.ti[bin->index].num_of_block = i;
            j -= 1;
            i -= 1;
        }
        buffer.num_of_block = j+1;

        if(j == 15 || i + 1 == bin->num_of_block){
            if(write_fcd_data(&buffer, out) != (j+1)){
                file_write_error(out->path);
                free(buffer.data);
                return 0;
            }

            if(mode & MODE_VERBOSE){
                PB->Position += buffer.num_of_block;
                block_view->Caption = Format("%5d / %5d", ARRAYOFCONST(((int)dt->position, (int)bin->num_of_block)));
            }

            Application->ProcessMessages();

            if(interrupt){
                switch(query_interrupt()){
                case IDOK:
                    free(buffer.data);
                    fclose(in);
                    return 0;
                default:
                    interrupt = false;
                }
            }
        }
    }

    free(buffer.data);

    return dt->position;
}
//---------------------------------------------------------------------------
LBN __fastcall TForm2::bin2wav(dao_track *bin, char *outfile)
{
    size_t i,j,n,m,max;
    char *buffer;

    FILE *in;
    FILE *out;

    char riff_head[44] = {
    	 'R',  'I',  'F',  'F', 0x00, 0x00, 0x00, 0x00,  'W',  'A',
         'V',  'E',  'f',  'm',  't',  ' ', 0x10, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x02, 0x00, 0x44, 0xAC, 0x00, 0x00, 0x10, 0xB1,
        0x02, 0x00, 0x04, 0x00, 0x10, 0x00, 'd',  'a',  't',  'a',
        0x00, 0x00, 0x00, 0x00
    };

    if(bin->type != DAO_TRACK_TYPE_AUDIO || bin->block_size < 2352){
        return 0;
    }

    in = fopen(bin->path, "rb");
    if(in == NULL){
        return 0;
    }

    fseek(in, bin->offset, SEEK_SET);

    out = fopen(outfile, "wb");
    if(out == NULL){
        fclose(in);
        file_create_error(outfile);
        return 0;
    }

    fwrite(riff_head, 1, 44, out);

    buffer = (char *)malloc(bin->block_size * 16);

    for(i=0;i<bin->num_of_block;i+=16){

        if(i+16 > bin->num_of_block){
            m = bin->num_of_block - i;
        }else{
            m = 16;
        }

        n = fread(buffer, 1, bin->block_size * m, in);

        if(n/bin->block_size < m){
            m = n / bin->block_size;
            bin->num_of_block = i + m;
        }

        for(j=0;j<m;j++){
            n = fwrite(buffer+(j*bin->block_size), 1, 2352, out);
            if(n != 2352){
                file_write_error(outfile);
                exit(EXIT_FAILURE);
            }
        }

        if(mode & MODE_VERBOSE){
            PB->Position += m;
            block_view->Caption = Format("%5d / %5d", ARRAYOFCONST(( (int)(i+m), (int)bin->num_of_block)));
        }

        Application->ProcessMessages();

        if(interrupt){
            switch(query_interrupt()){
            case IDOK:
                free(buffer);
                fclose(in);
                fclose(out);
                return 0;
            default:
                interrupt = false;
            }
        }
    }

    fseek(out, 0, SEEK_SET);
    max = 2352 * bin->num_of_block;

    int32_to_le_char_array(max+36, riff_head+4);
    int32_to_le_char_array(max, riff_head+40);

    fwrite(riff_head, 1, 44, out);

    free(buffer);
    fclose(in);
    fclose(out);

    return bin->num_of_block;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::fcd2fcd(char *fcd_file)
{
    int i,d;

    FCD fcd;
    char temporal[FILENAME_MAX];
    char buffer[32768];
    size_t n;
    size_t img_size;
    OFFSET_TABLE table;

    FILE *out;

    if(!open_fcd_file(fcd_file, &fcd)){
        fcd_open_error(fcd_file);
        return;
    }

    Form4->set_list(&fcd);

    Form4->fcd2fcd = true;
    Form4->output_file_edit->Enabled = false;
    Form4->change_output->Enabled = false;

    if(!(Form4->ShowModal() == mrOk)){
        exit(EXIT_FAILURE);
    }

    if((! fcd.dtl.num ) || (fcd.dtl.dt[0].offset >= 0x2776)){

        fclose(fcd.stream);
        fcd.stream = fopen(fcd.path, "rb+");
        write_fcd_info(&fcd, fcd.stream);
        close_fcd_file(&fcd);

        PB->Max = 0;

        mode |= MODE_OVERWRITE;

    }else{

        sprintf(temporal, "%s.%s", fcd_file, "new");
        out = fopen(temporal, "wb");
        if(out == NULL){
            temporal_create_error(temporal);
            exit(EXIT_FAILURE);
        }

        if(get_offset_table(&fcd, &table)){
            fcd.dtl.dt[0].offset = 0x2776;
            write_fcd_info(&fcd, out);

            d = 0x2776 + table.num_of_unit * 4 - table.offsets[0];
            for(i=0;i<table.num_of_unit;i++){
                write_le_int32(table.offsets[i] + d, out);
            }
            img_size = table.offsets[table.num_of_unit-1] - table.offsets[0];
            free(table.offsets);
        }else{
            fcd.dtl.dt[0].offset = 0x2776;
            write_fcd_info(&fcd, out);

            img_size = (fcd.dtl.dt[0].ti->num_of_block - 16) * fcd.dtl.dt[0].ti->block_size;
        }

        PB->Max = img_size;
    }

    for(i=0;i<fcd.atl.num;i++){
        if(check_sfx(fcd.atl.at[i].ti->filename, ".mp3")){
            PB->Max += fcd.atl.at[i].byte;
        }else if(!compare_directory(fcd.path, fcd.atl.at[i].ti->filename)){
            PB->Max += fcd.atl.at[i].byte;
        }
    }

    if(mode & MODE_VERBOSE && PB->Max){
        Show();
    }

    working = true;

    if(!(mode & MODE_OVERWRITE)){

        if(mode & MODE_VERBOSE){
            set_filename_view(fcd.path);
            track_view->Caption = Format("%d/%d", ARRAYOFCONST((fcd.dtl.dt[0].ti->index+1, fcd.cdi.num_of_track)));
            d = img_size / fcd.dtl.dt[0].ti->num_of_block;
        }

        while((n = fread(buffer, 1, 32768, fcd.stream)) > 0){
            fwrite(buffer, 1, n, out);

            if(mode & MODE_VERBOSE){
                PB->Position += n;
                block_view->Caption = Format("%5d / %5d", ARRAYOFCONST(( (int)(PB->Position / d), (int)fcd.dtl.dt[0].ti->num_of_block )) );
            }

            Application->ProcessMessages();

            if(interrupt){
                switch(query_interrupt()){
                case IDOK:
                    fclose(fcd.stream);
                    fclose(out);
                    remove(temporal);
                    return;
                default:
                    interrupt = false;
                }
            }
        }

        fclose(fcd.stream);
        fclose(out);

        remove(fcd.path);

        if(rename(temporal, fcd.path)){
            file_rename_error(errno, temporal, fcd.path);
            exit(EXIT_FAILURE);
        }
    }

    for(i=0;i<fcd.atl.num;i++){
        if(check_sfx(fcd.atl.at[i].ti->filename, ".mp3")){
            if(mode & MODE_VERBOSE){
                set_filename_view(fcd.atl.at[i].ti->filename);
                track_view->Caption = Format("%d/%d", ARRAYOFCONST((fcd.atl.at[i].ti->index+1, fcd.cdi.num_of_track)));
            }
            copy_mp3(&fcd, i);
        }else if(!compare_directory(fcd.path,  fcd.atl.at[i].ti->filename)){
            if(mode & MODE_VERBOSE){
                set_filename_view(fcd.atl.at[i].ti->filename);
                track_view->Caption = Format("%d/%d", ARRAYOFCONST((fcd.atl.at[i].ti->index+1, fcd.cdi.num_of_track)));
            }
            copy_wav(&fcd, i);
        }
    }

    working = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::set_language()
{
    LANGID id;

    id = GetUserDefaultLangID();

    if(id == 0x0411){
        language = LANGUAGE_TYPE_JAPANESE;
    }else{
        Font->Charset = ANSI_CHARSET;
        Font->Name = "Arial";
        Caption = "Converting Status";
        Label3->Caption = "File :  ";
        Label2->Caption = "Track :  ";
        Label1->Caption = "Block :  ";
        Button1->Caption = "Cancel";
        language = LANGUAGE_TYPE_ENGLISH;
    }
    
}
//---------------------------------------------------------------------------
void __fastcall TForm2::file_open_error(char *filename)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s J܂\n̓_mFĂ\n\n1. t@C݂Ă邩\n2. ANZX邩\n3. ̃vOr䂳ĂȂ", ARRAYOFCONST((filename)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't open %s\nCheck following points\n\n1. dose a file exist?\n2. have read permission?\n3. other programs lock", ARRAYOFCONST((filename)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm2::file_create_error(char *filename)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s J܂\n̓_mFĂ\n\n1. tH_݂Ă邩\n2. ݉\ȃtH_\n3. ̃vOr䂳ĂȂ\n4. ɏݕs\Ńt@C݂ĂȂ", ARRAYOFCONST((filename)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't create %s\nCheck following points\n\n1. dose a folder exist?\n2. have write permission?\n3. other porgrams lock", ARRAYOFCONST((filename)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::file_write_error(char *filename)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s ւ݂̏Ɏs܂", ARRAYOFCONST((filename)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Failed in writing to %s", ARRAYOFCONST((filename)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::mp3_open_error(char *mp3_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s J܂\n̓_mFĂ\n\n1. t@C݂Ă邩\n2. ANZX邩\n3. ̃vOr䂳ĂȂ\n4.  MP3 t@C", ARRAYOFCONST((mp3_file)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't open %s\nCheck following points\n\n1. dose a file exist?\n2. have read permission?\n3. other programs lock\n4. dosen't a MP3 break?", ARRAYOFCONST((mp3_file)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::cue_open_error(char *cue_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s J܂\n̓_mFĂ\n\n1. t@C݂Ă邩\n2. C[Wt@C݂Ă邩\n3. C[Wt@C BINARY `", ARRAYOFCONST((cue_file)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't open %s\nCheck following points\n\n1. dose a file exist?\n2. dose a image exist?\n3. is image format BINARY ?", ARRAYOFCONST((cue_file)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::fcd_open_error(char *fcd_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s J܂\n̓_mFĂ\n\n1. t@C݂Ă邩\n2. FCD t@CĂȂ", ARRAYOFCONST((fcd_file)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't open %s\nCheck following points\n\n1. dose a file exist?\n2. dosen't a FCD break", ARRAYOFCONST((fcd_file)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm2::temporal_create_error(char *temporal)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("ꎞt@C\n\n %s 쐬ł܂ł", ARRAYOFCONST((temporal)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't create temporaly file %s", ARRAYOFCONST((temporal)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::ccd_open_error(char *ccd_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s J܂\n̓_mFĂ\n\n1. t@C݂Ă邩\n2. C[Wt@C݂Ă邩\n3. [CloneCD]  Version  2 ɂȂĂ邩\n4. C[W Scramble ĂȂ", ARRAYOFCONST((ccd_file)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't open %s\nCheck following points\n\n1. dose a file exist?\n2. C[Wt@C݂Ă邩\n3. [CloneCD]  Version  2 ɂȂĂ邩\n4. C[W Scramble ĂȂ", ARRAYOFCONST((ccd_file)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::cdi_open_error(char *cdi_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s J܂\n̓_mFĂ\n\n1. t@C݂Ă邩\n2. CDI t@C쐬 Disc Juggler ̃o[W\n@ ȉ̃o[WȊO͕ϊł܂ij\n\n@ V1.01.199, V1.05.395, V2.00.409\n\n3. o[WAbvɃt@C`ύXȂǂƂ\n@ j̗pĂ\tgȂǌ̂Ăׂł\n4. ȃ\tg𗘗pĂ鏊Ƃ͉؂܂傤", ARRAYOFCONST((cdi_file)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't open %s\nCheck following points\n\n1. dose a file exist?\n2. version of DiscJugger what create CDI\n   converting enable versions are following only\n\n    V1.01.199, V1.05.395, V2.00.409", ARRAYOFCONST((cdi_file)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::nrg_open_error(char *nrg_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s J܂", ARRAYOFCONST((nrg_file)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Can't open %s", ARRAYOFCONST((nrg_file)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::fcd_has_no_data_track(char *fcd_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s Ƀf[^gbN͂܂", ARRAYOFCONST((fcd_file)));
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }else{
        error_msg = Format("%s has no data track", ARRAYOFCONST((fcd_file)));
        Application->MessageBox(error_msg.c_str(), "REPORT", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
int __fastcall TForm2::raw_mode_track_warning(char *fcd_file, int track, int block_size)
{
    int r;

    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s ̃gbN %.2d  RAW (MODE2 XA) tH[}bgł\n݃ubNTCY %d ɐݒ肳Ă܂\n\nϊ𑱍s܂H", ARRAYOFCONST((fcd_file, track, block_size)));
        r = Application->MessageBox(error_msg.c_str(), "x", MB_OKCANCEL|MB_ICONWARNING);
    }else{
        error_msg = Format("%s - track %.2d is RAW (MODE2 XA) format\nnow, block size is set to %d\n\ncontinue a convesion?", ARRAYOFCONST((fcd_file, track, block_size)));
        r = Application->MessageBox(error_msg.c_str(), "WARNING", MB_OKCANCEL|MB_ICONWARNING);
    }        
    return r;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::unknown_mode_track_error(char *fcd_file, int track)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s ̃gbN %.2d ͕sȃgbNł\nϊ܂", ARRAYOFCONST((fcd_file, track)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("%s - track %.2d is unknown format\nskip this track", ARRAYOFCONST((fcd_file, track)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::audio_mode_track_error(char *fcd_file, int track)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s ̃gbN %.2d  Audio gbNł\nϊ܂", ARRAYOFCONST((fcd_file, track)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("%s - track %.2d is audio track\nskip this track", ARRAYOFCONST((fcd_file, track)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::unknown_compression_error(char *fcd_file, int track)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s ̃gbN %.2d ͕sȈk`ł\nϊ܂", ARRAYOFCONST((fcd_file, track)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("%s - track %.2d is unknown compression format\ncan't convert", ARRAYOFCONST((fcd_file, track)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::move_next_track_error(char *fcd_file, int track)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s ̃gbN %.2d C[W擪ւ̈ړɎs܂", ARRAYOFCONST((fcd_file, track)) );
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Failed in the movement to the head of image\n\n  %s - track %.2d", ARRAYOFCONST((fcd_file, track)) );
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::add_track_data_error(char *iso_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s gbNXgɒǉł܂ł̓_mFĂ\n\n1. t@C݂Ă邩\n2. t@CTCY 2048/2336/2352 ̂ǂꂩŊ؂邩", ARRAYOFCONST((iso_file)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Failed in the addition to track list of %s\nCheck following points\n1. dose a file exist?\n2. is file size satisfied either one of 2048/2336/2352?", ARRAYOFCONST((iso_file)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::add_track_wav_error(char *wav_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s gbNXgɒǉł܂ł̓_mFĂ\n\n1. t@C݂Ă邩\n2.  WAV t@C\n3.  70 gbNo^ĂȂ", ARRAYOFCONST((wav_file)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Failed in the addition to track list of %s\nCheck following points\n1. dose a file exist?\n2. dosen't a WAV break?\n3. dosen't exceed 70 tracks?", ARRAYOFCONST((wav_file)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::add_track_mp3_error(char *mp3_file)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s gbNXgɒǉł܂ł\n̓_mFĂ\n\n1. t@C݂Ă邩\n2.  MP3 t@C\n3.  70 gbNo^ĂȂ", ARRAYOFCONST((mp3_file)));
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        error_msg = Format("Failed in the addition to track list of %s\nCheck following points\n1. dose a file exist?\n2. dosen't a MP3 break?\n3. dosen't exceed 70 tracks?", ARRAYOFCONST((mp3_file)));
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm2::file_rename_error(int error_number, char *before, char *after)
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        switch(error_number){
        case EEXIST:
            error_msg = Format("%s  %s ւ̃l[Ɏs܂\nt@C͊ɑ݂Ă܂", ARRAYOFCONST((before, after)));
            break;
        case ENOENT:
            error_msg = Format("%s  %s ւ̃l[Ɏs܂\nϊt@C݂܂", ARRAYOFCONST((before, after)));
            break;
        case ENOTSAM:
            error_msg = Format("%s  %s ւ̃l[Ɏs܂\nfoCXႢ܂", ARRAYOFCONST((before, after)));
            break;
        default:
            error_msg = Format("%s  %s ւ̃l[Ɏs܂\nsȃG[ł", ARRAYOFCONST((before, after)));
        }
        Application->MessageBox(error_msg.c_str(), "s", MB_OK|MB_ICONERROR);
    }else{
        switch(error_number){
        case EEXIST:
            error_msg = Format("Failed in rename to %s from %s\n%s already exists", ARRAYOFCONST((after, before, after)));
            break;
        case ENOENT:
            error_msg = Format("Failed in rename to %s from %s\n%s dosen't exist", ARRAYOFCONST((after, before, before)));
            break;
        case ENOTSAM:
            error_msg = Format("Failed in rename to %s from %s\ndifferent device", ARRAYOFCONST((after, before)));
            break;
        default:
            error_msg = Format("Failed in rename to %s from %s\nunknown error", ARRAYOFCONST((after, before)));
        }
        Application->MessageBox(error_msg.c_str(), "ERROR", MB_OK|MB_ICONERROR);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm2::cant_overwrite_conversion_multiple_image()
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = " ISO t@C͏㏑[hϊł܂\n\nʏ̕ϊs܂";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }else{
        error_msg = "Overwrite conversion is disabled at multiple DATA track\n\nnormal conversion will be executed";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm2::cant_overwrite_conversion_audio_cd()
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = "y CD ͏㏑[hϊł܂\n\nʏ̕ϊs܂";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }else{
        error_msg = "Overwrite conversion is disabled at AUDIO CD\n\nnormal conversion will be executed";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm2::cant_overwrite_conversion_cd_extra()
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = "f[^gbN擪ŖΏ㏑[hϊł܂\n\nʏ̕ϊs܂";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }else{
        error_msg = "Overwrite conversion is disabled at CD-Extra\n\nnormal conversion will be executed";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm2::cant_overwrite_conversion_2336_image()
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = "2336 C[W͏㏑[hϊł܂\n\nʏ̕ϊs܂";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }else{
        error_msg = "Overwrite conversion is disabled at 2336/block image\n\nnormal conversion will be executed";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }        
}
//---------------------------------------------------------------------------
void __fastcall TForm2::cant_overwrite_conversion_different_drive()
{
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = "قȂhCuւ͏㏑[hϊł܂\n\nʏ̕ϊs܂";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }else{
        error_msg = "Overwrite conversion is disabled for different drive\n\nnormal conversion will be executed";
        Application->MessageBox(error_msg.c_str(), "", MB_OK|MB_ICONINFORMATION);
    }        
}
//---------------------------------------------------------------------------
int __fastcall TForm2::query_overwrite(char *path)
{
    int r;
    
    if(language == LANGUAGE_TYPE_JAPANESE){
        error_msg = Format("%s ͊ɑ݂܂\n\n㏑܂H", ARRAYOFCONST((path)));
        r = Application->MessageBox(error_msg.c_str(), "₢킹", MB_OKCANCEL|MB_ICONQUESTION);
    }else{
        error_msg = Format("%s already exist\n\nOverwrite?", ARRAYOFCONST((path)));
        r = Application->MessageBox(error_msg.c_str(), "QUERY", MB_OKCANCEL|MB_ICONQUESTION);
    }        
    return r;
}
//---------------------------------------------------------------------------
int __fastcall TForm2::query_interrupt()
{
    int r;

    if(language == LANGUAGE_TYPE_JAPANESE){
        r = Application->MessageBox("ϊ𒆒f܂H", "₢킹", MB_OKCANCEL|MB_ICONQUESTION);
    }else{
        r = Application->MessageBox("Stop conversion?", "QUERY", MB_OKCANCEL|MB_ICONQUESTION);
    }        
    return r;
}
//---------------------------------------------------------------------------

